<?php $__env->startSection('content'); ?>
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="card card-primary card-tabs border-0 shadow-custom">
				<div class="card-header p-0 pt-1 border-grey">
					<ul class="nav nav-tabs" id="custom-tabs-two-tab" role="tablist">
						<li class="pt-2 px-3">
							<h3 class="card-title"><?php echo e(__('settings.title')); ?></h3>
						</li>
						<li class="nav-item">
							<a class="nav-link active" id="custom-tabs-change-logo-tab" data-toggle="pill"
								href="#custom-tabs-change-logo" role="tab" aria-controls="custom-tabs-change-logo"
								aria-selected="true"><?php echo e(__('settings.change_logo')); ?></a>
						</li>
						<li class="nav-item">
							<a class="nav-link" id="custom-tabs-two-profile-tab" data-toggle="pill"
								href="#custom-tabs-invoice-settings" role="tab"
								aria-controls="custom-tabs-invoice-settings" aria-selected="false"><?php echo e(__('settings.invoice_settings')); ?></a>
						</li>
						<li class="nav-item">
							<a class="nav-link" id="custom-tabs-options-tab" data-toggle="pill"
								href="#custom-tabs-options" role="tab" aria-controls="custom-tabs-options"
								aria-selected="false"><?php echo e(__('settings.options')); ?></a>
						</li>
					</ul>
				</div>
				<div class="card-body">
					<div class="tab-content" id="custom-tabs-two-tabContent">
						<div class="tab-pane fade show active" id="custom-tabs-change-logo" role="tabpanel"
							aria-labelledby="custom-tabs-change-logo-tab">
							<div class="row">
								<div class="col-md-6">
									<div class="form-group">
										<label for="upload-logo"><?php echo e(__('settings.upload_logo')); ?></label>
										<div id="content">
											<div id="upload-logo-dropzone" class="dropzone">
												<div class="dz-message">
													<h3 class="text-secondary"><?php echo e(__('settings.dropzone_title')); ?></h3>
													<?php echo e(__('settings.dropzone_subtitle')); ?> <br>
												</div>
												<div class="fallback">
													<input name="file" type="file" class="form-control" />
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-md-6">
									<div class="form-group">
										<label for="upload-favicon"><?php echo e(__('settings.upload_favicon')); ?></label>
										<div id="content">
											<div id="upload-favicon-dropzone" class="dropzone">
												<div class="dz-message">
													<h3 class="text-secondary"><?php echo e(__('settings.dropzone_title')); ?></h3>
													<?php echo e(__('settings.dropzone_subtitle')); ?> <br>
												</div>
												<div class="fallback">
													<input name="file" type="file" class="form-control" />
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="col-md-12">
									<div class="form-group">
										<label for="upload-login-image"><?php echo e(__('settings.upload_login_image')); ?></label>
										<div id="content">
											<div id="upload-login-image-dropzone" class="dropzone">
												<div class="dz-message">
													<h3 class="text-secondary"><?php echo e(__('settings.dropzone_title')); ?></h3>
													<?php echo e(__('settings.dropzone_subtitle')); ?> <br>
												</div>
												<div class="fallback">
													<input name="file" type="file" class="form-control" />
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>

						<div class="tab-pane fade" id="custom-tabs-invoice-settings" role="tabpanel"
							aria-labelledby="custom-tabs-invoice-settings-tab">
							<form method="post" action="<?php echo e(route('settings.store')); ?>">
								<?php echo e(csrf_field()); ?>


								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label for="brand_name"><?php echo e(__('settings.brand_name')); ?></label>
											<input value="<?php echo e(get_setting($settings, 'brand_name')); ?>" type="text"
												class="form-control" name="brand_name" id="brand_name">
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label for="phone"><?php echo e(__('settings.phone')); ?></label>
											<input value="<?php echo e(get_setting($settings, 'phone')); ?>" type="text"
												class="form-control" name="phone" id="phone">
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label for="email"><?php echo e(__('settings.email')); ?></label>
											<input value="<?php echo e(get_setting($settings, 'email')); ?>" type="email"
												class="form-control" name="email" id="email">
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label for="phone"><?php echo e(__('settings.address')); ?></label>
											<input value="<?php echo e(get_setting($settings, 'address')); ?>" type="text"
												class="form-control" name="address" id="address">
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label for="currency"><?php echo e(__('settings.select_country')); ?></label>
											<select class="form-control select2bs4" name="country" id="country">
												<?php $__currentLoopData = get_country_codes(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($country['country']); ?>"
													<?php if($country['country']==get_setting($settings, 'country' )): ?>
													selected <?php endif; ?>><?php echo e($country['country']); ?></option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<button type="submit" class="btn btn-primary mt-1"><?php echo e(__('settings.save_settings')); ?></button>
									</div>
								</div>
							</form>
						</div>
						<div class="tab-pane fade" id="custom-tabs-options" role="tabpanel"
							aria-labelledby="custom-tabs-options-tab">
							<form method="post" action="<?php echo e(route('settings.store')); ?>">
								<?php echo e(csrf_field()); ?>

								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label for="language"><?php echo e(__('settings.select_language')); ?></label>
											<select class="form-control select2bs4" name="language" id="language">
												<option value="en" <?php if('en'==get_setting($settings, 'language'
													)): ?> selected <?php endif; ?>>English</option>
												<option value="fr" <?php if('fr'==get_setting($settings, 'language')): ?> selected <?php endif; ?>>French</option>
											</select>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label for="timezone"><?php echo e(__('settings.select_timezone')); ?></label>
											<select class="form-control select2bs4" name="timezone" id="timezone">
												<?php $__currentLoopData = get_timezones(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($key); ?>"
													<?php if($key==get_setting($settings, 'timezone' )): ?>
													selected <?php endif; ?>><?php echo e($value); ?>

												</option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label for="date_format"><?php echo e(__('settings.date_format')); ?></label>
											<select class="form-control select2bs4" name="date_format" id="date_format">
												<?php $__currentLoopData = get_date_formats(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $format): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($format['date_format']); ?>"
													<?php if($format['date_format']==get_setting($settings, 'date_format' )): ?>
													selected <?php endif; ?>><?php echo e(format_current_date($format['date_format'])); ?>

												</option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<label for="currency"><?php echo e(__('settings.select_currency')); ?></label>
											<select class="form-control select2bs4" name="currency" id="currency">
												<?php $__currentLoopData = get_currency_list(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
												<option value="<?php echo e($currency['alpha3']); ?>"
													<?php if($currency['alpha3']==get_setting($settings, 'currency' )): ?>
													selected <?php endif; ?>><?php echo e($currency['name']); ?></option>
												<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
											</select>
										</div>
									</div>
								</div>
								<div class="row">
									<div class="col-lg-6">
										<button type="submit" class="btn btn-primary mt-1"><?php echo e(__('settings.save')); ?></button>
									</div>
								</div>
							</form>
						</div>
					</div>
				</div>
				<!-- /.card -->
			</div>
		</div>
	</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('styles'); ?>
<link href="<?php echo e(asset('assets/css/dropzone-overrides.css')); ?>" rel="stylesheet" type="text/css" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<!-- Custom Script -->
<script>
	Dropzone.autoDiscover = false

	// Start Upload Logo
	new Dropzone("#upload-logo-dropzone", {
		url: "<?php echo e(route('settings.update_logo')); ?>",
		method: "post",
		headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
		acceptedFiles: "image/*",
		addRemoveLinks: true,
		maxFiles: 1,
		init: function () {
			var instance = this;
			instance.on('sending', function (file, xhr, formData) {
				formData.append('upload_type', 'logo');
				$('#upload-logo-dropzone.dz-started .dz-message').css({
					'display': 'none',
				});
			});

			instance.on("addedfile", function (file) {
				if (instance.files.length > instance.options.maxFiles) {
					// Remove the excess files
					instance.removeFile(instance.files[0]);
				}
			});


			fetchUploadedImage('logo', instance);
		},
		renameFile: function (file) {
			var ext = getFileExtension(file.name);
			var timestamp = new Date().getTime();
			var newName = timestamp + "." + ext;
			return newName;
		},
		removedfile: function (file) {
			// var name = file.upload.filename;
			deleteRequestedImage('upload-logo-dropzone', 'logo', file);
		},
	});
	// End Upload Logo

	// Start Upload Favicon
	new Dropzone("#upload-favicon-dropzone", {
		url: "<?php echo e(route('settings.update_logo')); ?>",
		method: "post",
		headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
		acceptedFiles: "image/*",
		addRemoveLinks: true,
		maxFiles: 1,
		init: function () {
			var instance = this;
			instance.on('sending', function (file, xhr, formData) {
				formData.append('upload_type', 'favicon');
				$('#upload-favicon-dropzone.dz-started .dz-message').css({
					'display': 'none',
				});
			});

			instance.on("addedfile", function (file) {
				if (instance.files.length > instance.options.maxFiles) {
					// Remove the excess files
					instance.removeFile(instance.files[0]);
				}
			});

			fetchUploadedImage('favicon', instance);
		},
		renameFile: function (file) {
			var ext = getFileExtension(file.name);
			var timestamp = new Date().getTime();
			var newName = timestamp + "." + ext;
			return newName;
		},
		removedfile: function (file) {
			// var name = file.upload.filename;
			deleteRequestedImage('upload-favicon-dropzone', 'favicon', file);
		},
	});
	// End Upload Favicon

	// Start Upload Login Image
	new Dropzone("#upload-login-image-dropzone", {
		url: "<?php echo e(route('settings.update_logo')); ?>",
		method: "post",
		headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
		acceptedFiles: "image/*",
		addRemoveLinks: true,
		maxFiles: 1,
		maxFilesize: 500,
		init: function () {
			var instance = this;
			instance.on('sending', function (file, xhr, formData) {
				formData.append('upload_type', 'login_image');
				$('#upload-login-image-dropzone.dz-started .dz-message').css({
					'display': 'none',
				});
			});

			instance.on("addedfile", function (file) {
				if (instance.files.length > instance.options.maxFiles) {
					// Remove the excess files
					instance.removeFile(instance.files[0]);
				}
			});

			fetchUploadedImage('login_image', instance);
		},
		renameFile: function (file) {
			var ext = getFileExtension(file.name);
			var timestamp = new Date().getTime();
			var newName = timestamp + "." + ext;
			return newName;
		},
		removedfile: function (file) {
			deleteRequestedImage('upload-login-image-dropzone', 'login_image', file);
		},
	});
	// End Upload Login Image

	// Function to get the file extension
	function getFileExtension(fileName) {
		return fileName.slice((fileName.lastIndexOf(".") - 1 >>> 0) + 2);
	}

	function deleteRequestedImage(elementId, reqType, file) {
		$.ajaxSetup({
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
		});
		$.ajax({
			type: "post",
			url: "<?php echo e(route('settings.remove_logo')); ?>",
			data: { upload_type: reqType },
		});

		$('#' + elementId + '.dz-started .dz-message').css({
			'display': 'block',
		});

		var previewElement;
		return (previewElement = file.previewElement) != null ? (previewElement.parentNode.removeChild(file.previewElement)) : (void 0);
	}

	function fetchUploadedImage(reqType, instance) {
		$.ajaxSetup({
			headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
		});

		$.ajax({
			type: "post",
			url: "<?php echo e(route('settings.fetch_logo')); ?>",
			data: { upload_type: reqType },
			success: function (response) {
				if (response != undefined) {
					var mockFile = JSON.parse(response);
					if (mockFile.name != '') {
						instance.files.push(mockFile);
						instance.displayExistingFile(mockFile, imagesPath + '/' + mockFile.name);

						instance.emit("success", mockFile);
						instance.emit("complete", mockFile);
					}
				}
			},
			error: function (xhr, status, error) {
				// Handle errors here
				console.error("Error: " + error);
			}
		});
	}

	$(function () {
		//Initialize Select2 Elements
		$('.select2bs4').select2({
			theme: 'bootstrap4'
		})

		//Date picker
		$('#payment-date').datetimepicker({
			format: 'YYYY-MM-DD'
		});

	});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/settings/show.blade.php ENDPATH**/ ?>